/*:
 * @target MZ
 * @plugindesc <HideAfterLearn>付きスキルを「習得後のみ」メニュー/戦闘の一覧から非表示にします。
 * @author ChatGPT
 *
 * @help
 * スキルのメモ欄に <HideAfterLearn> を書くと、
 * そのスキルを「習得した後」はメニューと戦闘のスキル一覧に出ません。
 * （未習得の間は通常どおり表示されます）
 *
 * 競合を避けるため、他のスキル表示系プラグインよりも「下」に配置してください。
 *
 * Ver.1.1.0
 */

(() => {
  // 共通：習得後は隠すか？
  function shouldHideAfterLearn(actor, skill) {
    if (!actor || !skill) return false;
    if (!skill.meta || !skill.meta.HideAfterLearn) return false;
    return actor.isLearnedSkill && actor.isLearnedSkill(skill.id);
  }

  // スキル一覧（メニュー/戦闘どちらも継承でここを通ります）
  const _Window_SkillList_includes = Window_SkillList.prototype.includes;
  Window_SkillList.prototype.includes = function(item) {
    if (shouldHideAfterLearn(this._actor, item)) return false;
    return _Window_SkillList_includes.call(this, item);
  };

  // 念のため、リフレッシュ時にも弾く（外部プラグインでincludesをバイパスする対策）
  const _Window_SkillList_makeItemList = Window_SkillList.prototype.makeItemList;
  Window_SkillList.prototype.makeItemList = function() {
    _Window_SkillList_makeItemList.call(this);
    if (this._data && this._actor) {
      this._data = this._data.filter(s => !shouldHideAfterLearn(this._actor, s));
    }
  };
})();
